@extends('layouts.dashly1')
@section('title', $title)
@section('content')
    <!-- Page title -->
    <div class="page-title">
        <div class="row justify-content-between align-items-center">
            <div class="mb-3 col-md-6 mb-md-0">
            <h1 class="h2">
        Deposit into your account
    </h1>
            </div>
        </div>
    </div>
    <x-danger-alert />
    <x-success-alert />
       <x-success-alert />
   
    <div class="row">
        <div class="col-md-12">
            <div class="card ">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <form action="{{route('newdeposit')}}" method="post" >
                                @csrf
                                <div class="row" x-data>
                                    <div class="mb-4 col-md-12">
                                        <h5 class="card-title ">Enter Amount</h5>
                                        <input class="form-control " placeholder="Enter Amount"
                                            min="{{ $moresettings->minamt }}" type="number" name="amount" required>
                                    </div>
                                    <div class="mb-4 col-md-12">
                                        <input type="hidden" name="payment_method" id="paymethod">
                                    </div>
                                    <div class="mt-2 mb-1 col-md-12">
                                        <h5 class="card-title ">Choose Payment Method from the list below</h5>
                                    </div>
                                  
                                    
                                   
                                    <div class="mb-4 col-md-12">
                                        <!--<h5 class="card-title ">Select payment Method</h5>-->
                                        <select class="form-control" name="payment_method" required>
                                              @forelse ($dmethods as $method)
                                              <option value='{{$method->name}}'>{{$method->name}}</option>
                                           
                                              @empty
                                     
                                            <option class="">No Payment Method enabled at the moment, please check
                                                back later.</option>
                                                 @endforelse
                                                 
                                                  </select>
                                        </div>
                                
                                    @if (count($dmethods) > 0)
                                        <div class="mt-2 mb-1 col-md-12">
                                            <input type="submit" class="px-5 btn btn-primary btn-lg"
                                                value="Procced to Payment">
                                        </div>
                                        <input type="hidden" id="lastchosen" value="0">
                                    @endif
                            </form>
                        </div>
                        
                                <div class="card-footer">
                                    <div class="actions d-flex justify-content-between">
                                        <a href="{{ route('accounthistory') }}" class="action-item">
                                            <span class="btn-inner--icon">View deposit history</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @section('scripts')
        @parent
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"
            integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
        <!-- Bootstrap Notify -->
        <script src="{{ asset('dash2/libs/bootstrap-notify/bootstrap-notify.min.js') }} "></script>

        @include('user.script')

    @endsection
@endsection
