
@extends('layouts.base')

@section('title', 'Terms And Condition')


@section('content')
<!-- Hero Start -->

<!-- header ends here-->


<header id="header-security" class="o-clip o-nav-pull relative bg-cover bg-no-repeat" style="background-image: url(temp/custom/media/pages/security/97866883c8-1631610937/security-hero.jpg)" block-name="header-security">
<div class="o-container relative">
<div class="o-row items-center mt-32 mb-48 md:my-160">
<div class="o-col w-full sm:w-1/2 md:w-7/12">
<h1 class="b-heading s-heading s-heading--accent text-36 md:text-48 lg:text-64 leading-115 tracking-tight">
<strong>Maximum Security</strong> for&nbsp;Your Digital Assets </h1>
<h2 class="mt-20 text-20 md:text-28 leading-120 text-gray-500">
By {{$settings->sit_name}} leading partners in custody, overcollateralized lending model, and secure-by-design infrastructure. </h2>
</div>
<div class="o-col w-full sm:w-1/2 md:w-5/12 mt-32 sm:mt-0">
<div class="px-20 py-32 sm:py-48 md:p-48 border-1 border-gray-100 text-center rounded-lg shadow-md2 filter-blur">
<p class="s-card text-18 sm:text-22 leading-135 text-gray-600">
<strong>$375,000,000</strong> digital assets coverage via </p>
<div class="flex flex-col lg:flex-row items-center justify-between mt-20 gap-16">
<a class="b-anchor" href="https://www.bakkt.com/" target="_blank" rel="noopener noreferrer">
<img class="mb-12 lg:mb-0" src="temp/custom/media/pages/storage/images/a98c183741-1642608711/logo-bakkt.svg" alt="" width="140">
</a>
<a class="b-anchor" href="https://www.bitgo.com/" target="_blank" rel="noopener noreferrer">
<img class="mb-12 lg:mb-0" src="temp/custom/media/pages/storage/images/eff79fcd58-1631610940/logo-bitgo.svg" alt="" width="110">
</a>
<a class="b-anchor" href="https://www.ledger.com/" target="_blank" rel="noopener noreferrer">
<img src="temp/custom/media/pages/storage/images/1e930e6769-1631610940/logo-ledger.svg" alt="" width="120">
</a>
</div>
</div>
</div>
</div>
<div class="my-32 text-center">
<a class="b-link2" href="#security-partners">
Your assets’ security is guaranteed by
<span class="b-link2__icon b-link2__icon--r transform rotate-90">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
</header>
<section id="security-partners" class="o-container o-clip relative pt-80 md:py-160" block-name="logos-details">
<div class="max-w-xl md:max-w-4xl mx-auto md:mb-64">
<header class="s-lg-br mb-80 text-center">
<h2 class="mb-16 text-28 md:text-42 leading-115 font-medium text-gray-800">
{{$settings->sit_name}} Works With the Leading Authorities in Custody and Compliance </h2>
</header> </div>
<div class="o-row hidden md:flex items-center justify-between" ob-tabs>
<div class="o-col w-2/3 lg:w-7/12">
<div class="flex flex-wrap border-t-1 border-l-1 border-color-100">
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/e6b37076a6-1642608711/logo-black.svg" alt="">
</div>
</button>
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/47529dcb75-1642608711/logo-bitgo-short.svg" alt="">
</div>
</button>
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/8b06785e38-1631610937/logo-ledger.svg" alt="">
</div>
</button>
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/31797ec61c-1632402823/logo-armanino.svg" alt="">
</div>
</button>
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/a6b59c5372-1631610937/logo-jumio.svg" alt="" style="transform: scale(0.8)">
</div>
</button>
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/486e8a1595-1631610937/logo-securitize.svg" alt="">
</div>
</button>
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/95884deacf-1631610937/logo-aws.svg" alt="">
</div>
</button>
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/bc080d50ff-1631610937/logo-cloudflare.svg" alt="">
</div>
</button>
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/64d3425495-1631610937/logo-ssl-secured.svg" alt="">
</div>
</button>
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/784620404e-1631610937/logo-soc2.svg" alt="" style="transform: scale(0.9)">
</div>
</button>
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/a8e77d7322-1631610937/logo-ccss-level-3.svg" alt="">
</div>
</button>
<button class="b-logos-control__toggle grow w-1/3 border-r-1 border-b-1 border-color-100 px-32 lg:px-40 py-32" ob-tabs-toggle>
<div class="b-logos-control__toggle-content">
<img class="max-w-full max-h-48 mx-auto" src="temp/custom/media/pages/security/b44d321dd6-1631610937/logo-iso.svg" alt="" style="transform: scale(1.1)">
</div>
</button>
</div>
</div>
<div class="o-col w-1/3">
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
Bakkt </h3>
<p class="text-18 leading-135 text-color-500">
Bakkt is a trusted digital asset platform providing {{$settings->sit_name}} with Bitcoin and Ethereum custody in the Bakkt Warehouse, the company’s regulated custodian, which comprises both online (warm) and air-gapped (cold) digital asset storage to minimize risks. For extra protection, Bakkt’s wallets are covered by an insurance policy from a leading global carrier. </p>
<div class="mt-16">
<a class="b-link2" href="https://www.bakkt.com/" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
BitGo </h3>
<p class="text-18 leading-135 text-color-500">
BitGo is the first Qualified Custodian purpose-built for digital assets and a long-standing {{$settings->sit_name}} partner, serving primarily the retail side of our business. Private keys entrusted to BitGo are held in military-grade Class III vaults and carry $100M in insurance protections. </p>
<div class="mt-16">
<a class="b-link2" href="https://bitgo.com/" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
Ledger </h3>
<p class="text-18 leading-135 text-color-500">
Ledger Vault provides us with institutional-grade self-custody that is accessible 24/7/365 and fully addresses our retail and institutional clients’ needs for instant services. Ledger Vault carries $150M third-party insurance led by the Arch UK Lloyds of London syndicate. </p>
<div class="mt-16">
<a class="b-link2" href="https://enterprise.ledger.com/products/vault/" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
Armanino </h3>
<p class="text-18 leading-135 text-color-500">
As one of the leading accounting and business consulting firms in the US, Armanino is providing uninterrupted access to industry-standard attest reporting and a snapshot of {{$settings->sit_name}} total assets and liabilities, updated daily. </p>
<div class="mt-16">
<a class="b-link2" href="https://real-time-attest.trustexplorer.io/" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
Jumio </h3>
<p class="text-18 leading-135 text-color-500">
Jumio’s eKYC platform uses Informed AI that incorporates large data sets to deliver end-to-end identity verification. The Jumio KYX platform applies biometric-based authentication and AML screening and supports more than 3,500 ID documents across 200 jurisdictions. </p>
</div>
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
Securitize </h3>
<p class="text-18 leading-135 text-color-500">
Securitize enables ownership, management, and trading of digital securities (security tokens). The company is an SEC Registered Transfer Agent and its DS protocol allows for tokenized securities to be staked as collateral for {{$settings->sit_name}} Instant Crypto Credit Lines™. </p>
<div class="mt-16">
<a class="b-link2" href="#">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
Amazon Web Services </h3>
<p class="text-18 leading-135 text-color-500">
AWS provides even the most security-sensitive organizations with reliable cloud infrastructure. ISO 27001 and SOC 2 are just a couple of examples from the list of assurance programs with which AWS complies. </p>
<div class="mt-16">
<a class="b-link2" href="https://docs.aws.amazon.com/whitepapers/latest/aws-overview/security-and-compliance.html" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
Cloudflare </h3>
<p class="text-18 leading-135 text-color-500">
Cloudflare is a trusted security partner providing protection from critical vulnerabilities and threats, safeguarding network infrastructure against layer 3 and layer 4 DDoS attacks, and securing our team’s devices, networks, and internal applications. </p>
<div class="mt-16">
<a class="b-link2" href="https://www.cloudflare.com/products/security/" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
AES 256-bit SSL Secured </h3>
<p class="text-18 leading-135 text-color-500">
{{$settings->sit_name}} is 256-bit SSL secured, thus employing one of the most solid encryption methods used in modern encryption algorithms, protocols, and technologies. </p>
</div>
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
SOC 2 Type I & Type II </h3>
<p class="text-18 leading-135 text-color-500">
The SOC 2 compliance framework gauges the levels of security and protection of customer data. Type I evaluates an organization’s internal controls related to financial reporting, and Type II measures its preparedness to handle and protect customer information and data. </p>
<div class="mt-16">
<a class="b-link2" href="https://blog.bitgo.com/bitgo-completes-soc-2-type-2-37edd178f151" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
CCSS Level 3 </h3>
<p class="text-18 leading-135 text-color-500">
The CCSS is an open security standard for cryptocurrency storage and usage within an organization. The standard has three levels of security. The highest one– Level 3– requires multiple actors for all-critical actions, employs advanced authentication mechanisms, and distributes assets geographically and organisationally. </p>
<div class="mt-16">
<a class="b-link2" href="https://www2.deloitte.com/mt/en/pages/technology/articles/mt-article-cryptocurrency-security-standard-CCSS.html" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div ob-tabs-item>
<h3 class="mb-16 text-32 leading-115 font-medium text-color-800">
ISO/IEC 27001:2013 </h3>
<p class="text-18 leading-135 text-color-500">
ISO/IEC 27001:2013 Certified Information Security Management System comprises requirements for information security management systems (ISMS) and enables organizations to manage the security of financial information, intellectual property, employee details, or information entrusted by third parties. </p>
<div class="mt-16">
<a class="b-link2" href="https://www.iso.org/isoiec-27001-information-security.html" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
</div>
</div>
<div class="md:hidden -mt-32" ob-testimonials>
<div class="relative z-10" ob-testimonials-items>
<div class="will-change" ob-testimonials-items-rail>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
Bakkt </h3>
<p class="text-20 leading-135 text-color-700">
Bakkt is a trusted digital asset platform providing {{$settings->sit_name}} with Bitcoin and Ethereum custody in the Bakkt Warehouse, the company’s regulated custodian, which comprises both online (warm) and air-gapped (cold) digital asset storage to minimize risks. For extra protection, Bakkt’s wallets are covered by an insurance policy from a leading global carrier. </p>
<a class="b-link2 mt-16" href="https://www.bakkt.com/" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
BitGo </h3>
<p class="text-20 leading-135 text-color-700">
BitGo is the first Qualified Custodian purpose-built for digital assets and a long-standing {{$settings->sit_name}} partner, serving primarily the retail side of our business. Private keys entrusted to BitGo are held in military-grade Class III vaults and carry $100M in insurance protections. </p>
<a class="b-link2 mt-16" href="https://bitgo.com/" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
Ledger </h3>
<p class="text-20 leading-135 text-color-700">
Ledger Vault provides us with institutional-grade self-custody that is accessible 24/7/365 and fully addresses our retail and institutional clients’ needs for instant services. Ledger Vault carries $150M third-party insurance led by the Arch UK Lloyds of London syndicate. </p>
<a class="b-link2 mt-16" href="https://enterprise.ledger.com/products/vault/" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
Armanino </h3>
<p class="text-20 leading-135 text-color-700">
As one of the leading accounting and business consulting firms in the US, Armanino is providing uninterrupted access to industry-standard attest reporting and a snapshot of {{$settings->sit_name}} total assets and liabilities, updated daily. </p>
<a class="b-link2 mt-16" href="https://real-time-attest.trustexplorer.io/" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
Jumio </h3>
<p class="text-20 leading-135 text-color-700">
Jumio’s eKYC platform uses Informed AI that incorporates large data sets to deliver end-to-end identity verification. The Jumio KYX platform applies biometric-based authentication and AML screening and supports more than 3,500 ID documents across 200 jurisdictions. </p>
</div>
</div>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
Securitize </h3>
<p class="text-20 leading-135 text-color-700">
Securitize enables ownership, management, and trading of digital securities (security tokens). The company is an SEC Registered Transfer Agent and its DS protocol allows for tokenized securities to be staked as collateral for {{$settings->sit_name}} Instant Crypto Credit Lines™. </p>
<a class="b-link2 mt-16" href="#">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
Amazon Web Services </h3>
<p class="text-20 leading-135 text-color-700">
AWS provides even the most security-sensitive organizations with reliable cloud infrastructure. ISO 27001 and SOC 2 are just a couple of examples from the list of assurance programs with which AWS complies. </p>
<a class="b-link2 mt-16" href="https://docs.aws.amazon.com/whitepapers/latest/aws-overview/security-and-compliance.html" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
Cloudflare </h3>
<p class="text-20 leading-135 text-color-700">
Cloudflare is a trusted security partner providing protection from critical vulnerabilities and threats, safeguarding network infrastructure against layer 3 and layer 4 DDoS attacks, and securing our team’s devices, networks, and internal applications. </p>
<a class="b-link2 mt-16" href="https://www.cloudflare.com/products/security/" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
AES 256-bit SSL Secured </h3>
<p class="text-20 leading-135 text-color-700">
{{$settings->sit_name}} is 256-bit SSL secured, thus employing one of the most solid encryption methods used in modern encryption algorithms, protocols, and technologies. </p>
</div>
</div>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
SOC 2 Type I &amp; Type II </h3>
<p class="text-20 leading-135 text-color-700">
The SOC 2 compliance framework gauges the levels of security and protection of customer data. Type I evaluates an organization’s internal controls related to financial reporting, and Type II measures its preparedness to handle and protect customer information and data. </p>
<a class="b-link2 mt-16" href="https://blog.bitgo.com/bitgo-completes-soc-2-type-2-37edd178f151" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
CCSS Level 3 </h3>
<p class="text-20 leading-135 text-color-700">
The CCSS is an open security standard for cryptocurrency storage and usage within an organization. The standard has three levels of security. The highest one– Level 3– requires multiple actors for all-critical actions, employs advanced authentication mechanisms, and distributes assets geographically and organisationally. </p>
<a class="b-link2 mt-16" href="https://www2.deloitte.com/mt/en/pages/technology/articles/mt-article-cryptocurrency-security-standard-CCSS.html" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
<div class="b-testimonials-item flex items-center w-full pb-32" ob-testimonials-items-rail-item>
<div class="relative w-full sm:w-2/3 mx-auto">
<h3 class="mb-16 text-32 leading-120 font-medium text-color-700">
ISO/IEC 27001:2013 </h3>
<p class="text-20 leading-135 text-color-700">
ISO/IEC 27001:2013 Certified Information Security Management System comprises requirements for information security management systems (ISMS) and enables organizations to manage the security of financial information, intellectual property, employee details, or information entrusted by third parties. </p>
<a class="b-link2 mt-16" href="https://www.iso.org/isoiec-27001-information-security.html" target="_blank" rel="noopener noreferrer">
Visit Website
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
</div>
</div>
<div class="relative z-30 w-full h-2 bg-color-100">
<span class="h-full bg-accent-500" ob-testimonials-dash></span>
</div>
<div class="relative z-20 w-1/2 sm:w-1/3 mx-auto" ob-testimonials-logos>
<div class="items-center justify-between will-change" ob-testimonials-logos-rail="itemsPerScreen: 1">
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/e6b37076a6-1642608711/logo-black.svg" alt="" loading="lazy" draggable="false">
</div>
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/47529dcb75-1642608711/logo-bitgo-short.svg" alt="" loading="lazy" draggable="false">
</div>
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/8b06785e38-1631610937/logo-ledger.svg" alt="" loading="lazy" draggable="false">
</div>
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/31797ec61c-1632402823/logo-armanino.svg" alt="" loading="lazy" draggable="false">
</div>
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/a6b59c5372-1631610937/logo-jumio.svg" alt="" loading="lazy" draggable="false" style="transform: scale(0.8)">
</div>
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/486e8a1595-1631610937/logo-securitize.svg" alt="" loading="lazy" draggable="false">
</div>
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/95884deacf-1631610937/logo-aws.svg" alt="" loading="lazy" draggable="false">
</div>
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/bc080d50ff-1631610937/logo-cloudflare.svg" alt="" loading="lazy" draggable="false">
</div>
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/64d3425495-1631610937/logo-ssl-secured.svg" alt="" loading="lazy" draggable="false">
</div>
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/784620404e-1631610937/logo-soc2.svg" alt="" loading="lazy" draggable="false" style="transform: scale(0.9)">
</div>
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/a8e77d7322-1631610937/logo-ccss-level-3.svg" alt="" loading="lazy" draggable="false">
</div>
<div class="flex justify-center w-full px-24 py-32" ob-testimonials-logos-rail-item>
<img class="max-w-logo h-32 object-contain" src="temp/custom/media/pages/security/b44d321dd6-1631610937/logo-iso.svg" alt="" loading="lazy" draggable="false" style="transform: scale(1.1)">
</div>
</div>
</div>
</div>
</section>
<section class="t-dark t-mint-dark py-128 relative bg-color-0" block-name="text-items-badge">
<img class="absolute left-0 top-0 pointer-events-none select-none" src="temp/custom/media/pages/security/a058ecf2c0-1631610937/shapes-1.svg" alt="" draggable="false" data-visual1>
<img class="absolute right-0 bottom-0 pointer-events-none select-none" src="temp/custom/media/pages/security/8c30245634-1631610937/shapes-2.svg" alt="" draggable="false" data-visual2>
<div class="o-container relative z-10">
<img class="absolute left-50 top-0 z-n1 w-4/5 sm:w-1/2 -mt-64 sm:-mt-48 md:-mt-96 transform -translate-x-1/2 pointer-events-none select-none" src="temp/custom/media/pages/security/f0e4913d3f-1631610937/laurel-wreath.svg" alt="" draggable="false" data-visual1>
<h2 class="b-heading s-heading s-heading--accent mx-auto text-28 md:text-52 leading-115 tracking-tight text-center text-color-900" style="max-width: 16ch;">
Designed for Security, <strong>Driven by Trust</strong> </h2>
<div class="o-row justify-between mt-48">
<div class="o-col w-full md:w-1/2">
<div class="s-text2 m-clip text-color-600">
<p>We vouch for the trustworthiness of our best-in-class partners and we take pride in our own commitment: to protect your assets by lending them to institutions on an over-collateralized basis only.</p>
<p>Compliance with stringent regulations and global KYC and AML standards are testaments that security is {{$settings->sit_name}} utmost priority. That is why individuals, businesses, and institutions big and small trust {{$settings->sit_name}} with their data.</p>
<p>{{$settings->sit_name}} is cultivating a community of security-savvy users and employees to strengthen the blockchain and crypto lending ecosystems. This includes running regular internal security &amp; privacy workshops to ensure that {{$settings->sit_name}} staff is up to speed with today’s cybersecurity matters.</p> </div>
</div>
<div class="flex flex-wrap w-full md:w-5/12 mt-48 md:mt-0 -mb-48">
<div class="o-col w-1/2 sm:w-1/3 md:w-1/2 mb-48">
<div class="mb-16 text-48">
<i class="o-icon o-icon--duotone-mint"><svg width="48" height="49" viewBox="0 0 48 49" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M9 4.03418C6.23858 4.03418 4 6.27276 4 9.03418V35.0342C4 37.7956 6.23857 40.0342 9 40.0342H22.5798C22.2026 38.7668 22 37.4241 22 36.0342C22 28.3022 28.268 22.0342 36 22.0342C38.9745 22.0342 41.7323 22.9618 44 24.5435V9.03418C44 6.27276 41.7614 4.03418 39 4.03418H9Z" fill="#C2EADB" /><path d="M23 35.0342H13C10.7909 35.0342 9 33.2433 9 31.0342V13.0342C9 10.825 10.7909 9.03418 13 9.03418H35C37.2091 9.03418 39 10.825 39 13.0342V23.0342" stroke="#030405" stroke-width="2" /><path d="M4 16.0342H9" stroke="#030405" stroke-width="2" /><path d="M4 22.0342H9" stroke="#030405" stroke-width="2" /><path d="M4 28.0342H9" stroke="#030405" stroke-width="2" /><path d="M10 42.0342H17V45.0342C17 45.5865 16.5523 46.0342 16 46.0342H11C10.4477 46.0342 10 45.5865 10 45.0342V42.0342Z" fill="#00A76A" /><path d="M31 40.0342H38V43.0342C38 43.5865 37.5523 44.0342 37 44.0342H32C31.4477 44.0342 31 43.5865 31 43.0342V40.0342Z" fill="#00A76A" /><circle cx="36" cy="36.0342" r="12" fill="#00A76A" /><path d="M38.6175 32.5937C39.1273 32.5937 39.5405 32.1805 39.5405 31.6707C39.5405 31.1609 39.1273 30.7476 38.6175 30.7476V32.5937ZM33.3811 39.4748C32.8713 39.4748 32.458 39.8881 32.458 40.3979C32.458 40.9077 32.8713 41.321 33.3811 41.321V39.4748ZM38.6175 30.7476H34.9084V32.5937H38.6175V30.7476ZM34.9084 36.9574H37.0902V35.1112H34.9084V36.9574ZM37.0902 39.4748H33.3811V41.321H37.0902V39.4748ZM38.3489 38.2161C38.3489 38.9113 37.7854 39.4748 37.0902 39.4748V41.321C38.805 41.321 40.1951 39.9309 40.1951 38.2161H38.3489ZM37.0902 36.9574C37.7854 36.9574 38.3489 37.5209 38.3489 38.2161H40.1951C40.1951 36.5013 38.805 35.1112 37.0902 35.1112V36.9574ZM31.8035 33.8525C31.8035 35.5673 33.1936 36.9574 34.9084 36.9574V35.1112C34.2132 35.1112 33.6496 34.5477 33.6496 33.8525H31.8035ZM34.9084 30.7476C33.1936 30.7476 31.8035 32.1377 31.8035 33.8525H33.6496C33.6496 33.1573 34.2132 32.5937 34.9084 32.5937V30.7476Z" fill="#030405" /><path d="M36.9192 30.0342C36.9192 29.5244 36.5059 29.1111 35.9961 29.1111C35.4863 29.1111 35.073 29.5244 35.073 30.0342H36.9192ZM35.073 42.0342C35.073 42.544 35.4863 42.9573 35.9961 42.9573C36.5059 42.9573 36.9192 42.544 36.9192 42.0342H35.073ZM36.9192 31.6705V30.0342H35.073V31.6705H36.9192ZM35.073 40.3978V42.0342H36.9192V40.3978H35.073Z" fill="#030405" /></svg></i> </div>
<h3 class="pr-16 text-16 leading-135 font-medium text-color-600">
Only Lending on Over-Collateralized Basis </h3>
</div>
<div class="o-col w-1/2 sm:w-1/3 md:w-1/2 mb-48">
<div class="mb-16 text-48">
<i class="o-icon o-icon--duotone-mint"><svg width="48" height="49" viewBox="0 0 48 49" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16.8119 7.86249C17.8215 7.86249 18.6399 7.04404 18.6399 6.03442C18.6399 5.02481 17.8215 4.20636 16.8119 4.20636V7.86249ZM31.2302 4.20636C30.2206 4.20636 29.4021 5.02481 29.4021 6.03442C29.4021 7.04404 30.2206 7.86249 31.2302 7.86249V4.20636ZM16.8119 43.8625C17.8215 43.8625 18.6399 43.044 18.6399 42.0344C18.6399 41.0248 17.8215 40.2064 16.8119 40.2064V43.8625ZM31.2302 40.2064C30.2206 40.2064 29.4021 41.0248 29.4021 42.0344C29.4021 43.044 30.2206 43.8625 31.2302 43.8625V40.2064ZM4.17194 16.892C4.17194 17.9016 4.99039 18.72 6 18.72C7.00961 18.72 7.82806 17.9016 7.82806 16.892H4.17194ZM7.82806 31.2687C7.82806 30.2591 7.00961 29.4406 6 29.4406C4.99039 29.4406 4.17194 30.2591 4.17194 31.2687H7.82806ZM40.1719 16.892C40.1719 17.9016 40.9904 18.72 42 18.72C43.0096 18.72 43.8281 17.9016 43.8281 16.892H40.1719ZM43.8281 31.2687C43.8281 30.2591 43.0096 29.4406 42 29.4406C40.9904 29.4406 40.1719 30.2591 40.1719 31.2687H43.8281ZM8.74209 7.86249H16.8119V4.20636H8.74209V7.86249ZM31.2302 7.86249H39.2579V4.20636H31.2302V7.86249ZM16.8119 40.2064H8.7421V43.8625H16.8119V40.2064ZM39.2579 40.2064H31.2302V43.8625H39.2579V40.2064ZM7.82806 16.892V8.77652H4.17194V16.892H7.82806ZM7.82806 39.2923V31.2687H4.17194V39.2923H7.82806ZM40.1719 8.77652V16.892H43.8281V8.77652H40.1719ZM40.1719 31.2687V39.2923H43.8281V31.2687H40.1719ZM8.7421 40.2064C8.23729 40.2064 7.82806 39.7971 7.82806 39.2923H4.17194C4.17194 41.8164 6.21807 43.8625 8.7421 43.8625V40.2064ZM39.2579 43.8625C41.7819 43.8625 43.8281 41.8164 43.8281 39.2923H40.1719C40.1719 39.7971 39.7627 40.2064 39.2579 40.2064V43.8625ZM39.2579 7.86249C39.7627 7.86249 40.1719 8.27171 40.1719 8.77652H43.8281C43.8281 6.25249 41.7819 4.20636 39.2579 4.20636V7.86249ZM8.74209 4.20636C6.21807 4.20636 4.17194 6.25248 4.17194 8.77652H7.82806C7.82806 8.27171 8.23729 7.86249 8.74209 7.86249V4.20636Z" fill="#C2EADB" /><path d="M22.9453 24.502C17.3803 24.502 12.8555 29.0268 12.8555 34.5918C12.8555 35.632 13.6876 36.5161 14.7798 36.5161H32.9311C33.9713 36.5161 34.8555 35.684 34.8555 34.5918C34.8555 29.0268 30.3306 24.502 24.7656 24.502H22.9453Z" fill="#00A76A" /><path d="M23.8812 11.552C20.7086 11.552 18.1602 14.1005 18.1602 17.273C18.1602 20.4456 20.7086 23.0461 23.8812 23.0461C27.0538 23.0461 29.6022 20.4976 29.6022 17.273C29.6022 14.1525 27.0538 11.552 23.8812 11.552Z" fill="#00A76A" /></svg></i> </div>
<h3 class="pr-16 text-16 leading-135 font-medium text-color-600">
Biometric-Based Identity Verification </h3>
</div>
<div class="o-col w-1/2 sm:w-1/3 md:w-1/2 mb-48">
<div class="mb-16 text-48">
<i class="o-icon o-icon--duotone-mint"><svg width="48" height="49" viewBox="0 0 48 49" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M13.1571 15.2231C14.988 10.0415 18.1842 5.51834 22.3074 2.09839C10.948 2.96268 2 12.4535 2 24.0342C2 35.6149 10.9478 45.1057 22.3071 45.9701C18.2255 42.5846 15.0524 38.1179 13.2128 33.0017H6.40039V15.5081H13.1009C13.1055 15.4132 13.1239 15.3173 13.1571 15.2231ZM13.6127 16.4297V16.9083C13.7553 16.7831 13.9017 16.6655 14.0516 16.5554C13.9567 16.5508 13.861 16.5324 13.7668 16.4992C13.7127 16.48 13.6612 16.4567 13.6127 16.4297ZM15.0084 15.9745C16.0307 15.4703 17.1706 15.2433 18.3641 15.2433C19.0478 15.2433 19.757 15.3124 20.4636 15.495C21.0608 15.6473 21.6405 15.8431 22.1552 16.1077C22.5617 16.3168 22.9447 16.549 23.2871 16.7992C23.5608 16.9993 23.8952 17.2692 24.1706 17.5992L24.8304 18.3323C24.976 18.1706 25.1284 18.0122 25.2876 17.8573C27.0886 16.1043 29.3371 15.2341 31.8715 15.2341C32.1612 15.2341 32.4473 15.2455 32.7294 15.2683C30.9244 10.5195 27.8805 6.3942 24 3.29959C19.9512 6.52838 16.8132 10.8791 15.0429 15.8895C15.0326 15.9186 15.0211 15.9469 15.0084 15.9745ZM34.8909 15.6922C36.2092 16.117 37.4079 16.8379 38.4553 17.8573C40.2427 19.597 41.1753 21.7694 41.1753 24.2549C41.1753 26.7371 40.245 28.9196 38.4553 30.6616C37.3956 31.6931 36.1809 32.4189 34.8442 32.8416C34.8438 32.8429 34.8433 32.8442 34.8429 32.8456C33.012 38.0271 29.8159 42.5502 25.6929 45.9701C37.0522 45.1057 46 35.6149 46 24.0342C46 12.4535 37.052 2.96268 25.6926 2.09839C29.8158 5.51834 33.012 10.0415 34.8429 15.2231C34.8979 15.3789 34.9121 15.5391 34.8909 15.6922ZM32.5486 33.2636C32.3253 33.2777 32.0995 33.2848 31.8715 33.2848C29.3371 33.2848 27.0886 32.4146 25.2876 30.6616C25.0679 30.4477 24.8611 30.2272 24.6674 30.0003C24.3388 30.5843 23.9044 31.1177 23.3647 31.5899C21.9699 32.8104 20.1783 33.2848 18.2728 33.2848C17.4933 33.2848 16.7146 33.1904 15.9608 32.9958C15.7264 32.9354 15.4942 32.8672 15.2668 32.7904C17.0713 37.5434 20.1168 41.6723 24 44.7691C27.7538 41.7755 30.7247 37.8175 32.5486 33.2636ZM30.459 22.7522C30.0687 23.1468 29.8713 23.6027 29.8713 24.264C29.8713 24.9276 30.0699 25.3775 30.4504 25.7581L30.4591 25.7667L30.4676 25.7755C30.8576 26.1742 31.282 26.3555 31.8715 26.3555C32.4609 26.3555 32.8853 26.1742 33.2753 25.7755L33.2838 25.7667L33.2925 25.7581C33.673 25.3775 33.8717 24.9276 33.8717 24.264C33.8717 23.6027 33.6742 23.1468 33.2839 22.7522L33.2753 22.7435C32.8766 22.3358 32.4484 22.1542 31.8715 22.1542C31.2945 22.1542 30.8663 22.3358 30.4676 22.7434L30.459 22.7522Z" fill="#C2EADB" /><path d="M9 30.7439H11.7776V17.3151H9V30.7439Z" fill="#00A76A" /><path d="M20.501 26.8108C20.501 27.3165 20.3116 27.7285 19.9328 28.0469C19.554 28.3746 19.04 28.5338 18.3727 28.5338C17.7955 28.5338 17.2364 28.4027 16.7133 28.1312C16.1812 27.869 15.8386 27.6536 15.6853 27.4944C15.5319 27.3352 15.4147 27.2041 15.3335 27.1011L13.6652 28.8241L13.8726 29.0583C13.9898 29.2081 14.1882 29.3954 14.4678 29.6108C14.7383 29.8355 15.063 30.0509 15.4237 30.2569C15.7845 30.4723 16.2534 30.6596 16.8125 30.8094C17.3716 30.9593 17.9578 31.0342 18.553 31.0342C20.0861 31.0342 21.2855 30.6409 22.1513 29.8542C23.017 29.0676 23.4499 28.0563 23.4499 26.8108C23.4499 25.9305 23.2335 25.2094 22.7916 24.6288C22.3587 24.0576 21.8266 23.6456 21.1954 23.3927C20.5641 23.1492 19.9418 22.9245 19.3196 22.7372C18.6973 22.5499 18.1652 22.3251 17.7324 22.0536C17.2995 21.782 17.074 21.4168 17.074 20.9673C17.074 20.574 17.2364 20.2275 17.561 19.9466C17.8857 19.6656 18.3095 19.5251 18.8326 19.5251C19.2745 19.5251 19.6983 19.6375 20.1132 19.8435C20.528 20.0589 20.8076 20.2275 20.9338 20.3586C21.0601 20.4897 21.1593 20.5927 21.2314 20.6864L22.8908 18.8603L22.7284 18.673C22.6292 18.5419 22.4579 18.3827 22.2234 18.2047C21.9889 18.0268 21.7094 17.8489 21.3938 17.6803C21.0781 17.5118 20.6723 17.3619 20.1763 17.2308C19.6893 17.0997 19.1753 17.0435 18.6432 17.0435C17.3085 17.0435 16.2173 17.4275 15.3786 18.1954C14.5399 18.9633 14.1161 19.8904 14.1161 20.9767C14.1161 21.8569 14.3415 22.578 14.7744 23.1586C15.2163 23.7298 15.7484 24.1419 16.3706 24.3947C16.9929 24.6382 17.6151 24.8536 18.2464 25.0409C18.8777 25.2282 19.4098 25.4529 19.8426 25.7338C20.2755 26.0054 20.501 26.3613 20.501 26.8108Z" fill="#00A76A" /><path d="M27.8355 24.0389C27.8355 22.8027 28.2323 21.7539 29.0439 20.9017C29.8466 20.0496 30.8295 19.6188 31.9839 19.6188C33.1382 19.6188 34.1212 20.0496 34.9238 20.9017C35.7354 21.7539 36.1322 22.8027 36.1322 24.0389C36.1322 25.275 35.7354 26.3238 34.9238 27.1666C34.1212 28.0188 33.1382 28.4402 31.9839 28.4402C30.8295 28.4402 29.8466 28.0188 29.0439 27.1666C28.2323 26.3238 27.8355 25.275 27.8355 24.0389ZM24.9677 24.0295C24.9677 25.9586 25.6441 27.6161 26.9968 28.9833C28.3495 30.3506 30.0179 31.0342 31.9839 31.0342C33.9498 31.0342 35.6182 30.3506 36.9709 28.9833C38.3236 27.6161 39 25.9586 39 24.0295C39 22.1004 38.3236 20.4522 36.9709 19.085C35.6182 17.7178 33.9498 17.0342 31.9839 17.0342C30.0179 17.0342 28.3495 17.7178 26.9968 19.085C25.6441 20.4522 24.9677 22.1004 24.9677 24.0295Z" fill="#00A76A" /></svg></i> </div>
<h3 class="pr-16 text-16 leading-135 font-medium text-color-600">
ISO/IEC 27001<br />
Certified </h3>
</div>
<div class="o-col w-1/2 sm:w-1/3 md:w-1/2 mb-48">
<div class="mb-16 text-48">
<i class="o-icon o-icon--duotone-mint"><svg width="48" height="49" viewBox="0 0 48 49" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M6 20.0344C6 18.9299 6.89543 18.0344 8 18.0344H40C41.1046 18.0344 42 18.9299 42 20.0344V38.0344C42 42.4527 38.4183 46.0344 34 46.0344H14C9.58172 46.0344 6 42.4527 6 38.0344V20.0344Z" fill="#C2EADB" /><path d="M11 4.03418C11 2.92961 11.8954 2.03418 13 2.03418H35C36.1046 2.03418 37 2.92961 37 4.03418V16.0342H11V4.03418Z" fill="#00A76A" /><rect x="16" y="7.03418" width="5" height="4" rx="1" stroke="#030405" stroke-width="2" /><rect x="27" y="7.03418" width="5" height="4" rx="1" stroke="#030405" stroke-width="2" /></svg></i> </div>
<h3 class="pr-16 text-16 leading-135 font-medium text-color-600">
Segregated Multi-Signature Wallets </h3>
</div>
<div class="o-col w-1/2 sm:w-1/3 md:w-1/2 mb-48">
<div class="mb-16 text-48">
<i class="o-icon o-icon--duotone-mint"><svg width="48" height="49" viewBox="0 0 48 49" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M3 10.8918C3 9.42414 4.06067 8.16913 5.49224 7.84564C7.70975 7.34455 10.9822 6.46847 13.5 5.21739C14.9878 4.47809 16.4757 3.60785 17.8702 2.79221L17.8702 2.79219C20.4122 1.30537 22.6439 0 24 0C25.3561 0 27.5878 1.30538 30.1298 2.79219C31.5243 3.60784 33.0122 4.47809 34.5 5.21739C37.0178 6.46847 40.2903 7.34455 42.5078 7.84564C43.9393 8.16913 45 9.42414 45 10.8918V20.4059C45 23.0966 44.6334 25.7433 43.9306 28.2712C43.8955 28.2261 43.8601 28.1812 43.8242 28.1364C42.2875 26.2161 41.1946 24.6663 40.3942 23.4507C40.4877 22.6027 40.5352 21.7456 40.5352 20.8832V13.9492C40.5352 12.3385 39.3772 11.001 37.8611 10.6575C36.2145 10.2844 33.8723 9.64997 32.1051 8.7719C31.0213 8.23333 29.9541 7.60908 28.9203 7.00435L28.9203 7.00432C28.4824 6.74818 28.0505 6.49554 27.6258 6.25439C26.9299 5.85918 26.2515 5.49466 25.6338 5.22772C25.0382 4.9704 24.3909 4.75439 23.7852 4.75439C23.1795 4.75439 22.5321 4.9704 21.9366 5.22772C21.3188 5.49466 20.6404 5.85918 19.9445 6.25439C19.5199 6.49547 19.0882 6.74803 18.6504 7.0041L18.65 7.00433C17.6162 7.60906 16.5491 8.23332 15.4652 8.7719C13.6981 9.64997 11.3558 10.2844 9.70918 10.6575C8.19316 11.001 7.03516 12.3385 7.03516 13.9492V20.8793C7.03516 29.2873 11.5495 37.2023 19.1632 40.9231C20.1991 41.4294 21.1453 41.8713 21.9003 42.1888C22.2768 42.347 22.6196 42.4803 22.9099 42.5757C23.1626 42.6587 23.4925 42.7544 23.7895 42.7544C24.0865 42.7544 24.4163 42.6587 24.6689 42.5757C24.7036 42.5643 24.739 42.5524 24.7752 42.5399C25.3823 44.1152 26.3219 45.5254 27.5079 46.6843C25.7722 47.4851 24.4741 48 24.0058 48C23.3484 48 21.054 46.9851 18.2089 45.589C8.6914 40.9186 3 31.0025 3 20.4008V10.8918ZM38.5352 20.4812C38.4445 20.3434 38.3561 20.2153 38.2709 20.1022C38.1412 19.9298 37.945 19.6896 37.6808 19.4821C37.4022 19.2633 36.9346 18.9934 36.3081 18.9937C35.1694 18.9942 34.6039 19.8593 34.4578 20.1061C34.2491 20.4587 34.1261 20.8466 34.0465 21.1603C33.8797 21.8172 33.7806 22.6547 33.7362 23.5645C33.7143 24.0146 33.7049 24.5002 33.7099 25.0143C33.5117 24.928 33.2818 24.8692 33.0156 24.8529C32.5063 24.8217 32.0685 24.9708 31.8239 25.0679C31.5368 25.182 31.2555 25.3328 30.9961 25.4912C30.4741 25.8099 29.9044 26.2433 29.3427 26.7402C28.2259 27.7281 26.9863 29.104 26.1165 30.6289C24.4537 33.5441 24 35.9859 24 38.3527C24 39.1268 24.0755 39.8833 24.2196 40.6152C24.1569 40.6377 24.0985 40.6579 24.0443 40.6757C23.904 40.7218 23.8239 40.741 23.7895 40.749C23.7551 40.741 23.6748 40.7218 23.5343 40.6756C23.3161 40.6039 23.0283 40.4935 22.6755 40.3451C21.9718 40.0493 21.0647 39.6264 20.0413 39.1262C13.1727 35.7695 9.03516 28.5906 9.03516 20.8793V13.9492C9.03516 13.3285 9.4909 12.7577 10.1512 12.608C11.8298 12.2276 14.3651 11.5518 16.3551 10.563C17.5033 9.99245 18.6688 9.31081 19.7255 8.69279L19.7257 8.69267C20.1479 8.44575 20.5527 8.20899 20.9321 7.99353C21.6143 7.60613 22.2156 7.28586 22.7298 7.06367C23.2663 6.83187 23.6034 6.75439 23.7852 6.75439C23.967 6.75439 24.304 6.83187 24.8405 7.06367C25.3547 7.28586 25.956 7.60613 26.6382 7.99353C27.0177 8.20902 27.4226 8.44582 27.8448 8.69278L27.8448 8.69279L27.8449 8.6928C28.9015 9.31081 30.067 9.99246 31.2152 10.563C33.2052 11.5518 35.7405 12.2277 37.4191 12.608C38.0794 12.7577 38.5352 13.3285 38.5352 13.9492V20.4812ZM33.1996 28.5318C33.2109 28.5274 33.216 28.5258 33.2156 28.5263C33.2151 28.5267 33.2083 28.5295 33.1957 28.5334L33.1996 28.5318Z" fill="#C2EADB" /><path fill-rule="evenodd" clip-rule="evenodd" d="M25.8647 38.3527H25.8635C25.8635 43.7561 30.2438 48.1363 35.6471 48.1363C41.0504 48.1363 45.4307 43.7561 45.4307 38.3527H45.4285C45.4285 38.3228 45.4197 33.1113 42.3704 29.301C39.6932 25.9557 38.3166 23.6889 37.5055 22.3534C36.8865 21.3341 36.5969 20.8573 36.31 20.8574C35.6083 20.8577 35.1996 25.2485 36.0556 30.0676C36.6844 33.6078 34.7415 34.7203 33.4588 33.9407C32.389 33.2906 32.7045 30.7923 32.9416 28.9136C33.0959 27.692 33.217 26.7324 32.9028 26.7131C32.1054 26.6643 29.2244 28.9437 27.7364 31.5524C26.2484 34.1611 25.8647 36.2796 25.8647 38.3527Z" fill="#00A76A" /></svg></i> </div>
<h3 class="pr-16 text-16 leading-135 font-medium text-color-600">
Extensive Firewall Server Architecture </h3>
</div>
<div class="o-col w-1/2 sm:w-1/3 md:w-1/2 mb-48">
<div class="mb-16 text-48">
<i class="o-icon o-icon--duotone-mint"><svg width="48" height="49" viewBox="0 0 48 49" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M5.47428 23.4859C5.47428 20.4836 7.90625 18.0491 10.9071 18.0491C13.9079 18.0491 16.3399 20.4836 16.3399 23.4859C16.3399 26.4881 13.9079 28.9226 10.9071 28.9226C7.90625 28.9226 5.47428 26.4881 5.47428 23.4859ZM0.0214844 41.493C0.0214844 35.9975 4.47642 31.5426 9.97185 31.5426H11.8456C14.5923 31.5426 17.0791 32.6556 18.8796 34.4551C15.1292 35.8306 12.2462 39.0061 11.2755 42.9361H1.46456C0.667571 42.9361 0.0214844 42.29 0.0214844 41.493ZM36.7225 42.9362H46.5338C47.3308 42.9362 47.9769 42.2901 47.9769 41.4931C47.9769 35.9977 43.522 31.5427 38.0266 31.5427H36.1528C33.406 31.5427 30.9192 32.6557 29.1187 34.4552C32.869 35.8308 35.7518 39.0063 36.7225 42.9362ZM31.6552 23.486C31.6552 20.4837 34.0872 18.0492 37.088 18.0492C40.0889 18.0492 42.5208 20.4837 42.5208 23.486C42.5208 26.4882 40.0889 28.9227 37.088 28.9227C34.0872 28.9227 31.6552 26.4882 31.6552 23.486Z" fill="#C2EADB" /><path fill-rule="evenodd" clip-rule="evenodd" d="M18.5661 27.8525C18.5661 24.8503 20.998 22.4158 23.9989 22.4158C26.9997 22.4158 29.4317 24.8503 29.4317 27.8525C29.4317 30.8548 26.9997 33.2893 23.9989 33.2893C20.998 33.2893 18.5661 30.8548 18.5661 27.8525ZM13.1133 45.8597C13.1133 40.3643 17.5682 35.9093 23.0637 35.9093H24.9374C30.4329 35.9093 34.8878 40.3643 34.8878 45.8597C34.8878 46.6567 34.2417 47.3028 33.4447 47.3028H14.5564C13.7594 47.3028 13.1133 46.6567 13.1133 45.8597Z" fill="#C2EADB" /><path fill-rule="evenodd" clip-rule="evenodd" d="M22.4627 1.82428L22.4628 1.82428L22.4628 1.82426C22.6487 1.71545 22.8239 1.61289 22.9834 1.52227C23.2875 1.34941 23.5378 1.21688 23.7415 1.12879C23.8952 1.06235 23.9753 1.04251 24 1.03662C24.0247 1.04251 24.1048 1.06235 24.2585 1.12879C24.4622 1.21688 24.7125 1.34941 25.0166 1.52227C25.1761 1.61289 25.3513 1.71547 25.5372 1.82428C26.0194 2.10647 26.5732 2.43064 27.1094 2.69729C28.0984 3.18913 29.3425 3.51134 30.1094 3.68218V7.58108C30.1094 10.4278 28.5759 13.047 26.0756 14.3074C25.4746 14.6103 24.927 14.8759 24.5032 15.0637C24.2905 15.158 24.1227 15.2266 24.0019 15.2698C23.881 15.2266 23.713 15.1579 23.4999 15.0635C23.0758 14.8756 22.5277 14.6099 21.9262 14.3069C19.4249 13.0467 17.8906 10.427 17.8906 7.57954V3.68218C18.6575 3.51134 19.9016 3.18913 20.8906 2.69729C21.4268 2.43064 21.9806 2.10648 22.4627 1.82428Z" fill="#00A76A" /></svg></i> </div>
<h3 class="pr-16 text-16 leading-135 font-medium text-color-600">
<a href="#" class="underline">Community-Driven Vulnerability Disclosure</a> </h3>
</div>
</div>
</div>
<div class="sm:flex items-center justify-between mt-64 px-24 sm:px-48 py-24 text-center text-white rounded-md" style="background-color: #003399">
<img class="sm:absolute left-50 transform sm:-translate-x-1/2 inline-block h-72 select-none" src="temp/custom/media/pages/security/2b3c036931-1631610937/institution-stars.svg" alt="" draggable="false" data-visual2>
<h3 class="s-heading max-w-sm mt-24 mb-32 sm:my-0 text-22 sm:text-18 md:text-22 leading-135 font-medium sm:text-left">
<strong>Licensed &amp; Regulated</strong><br />
Digital Assets Institution </h3>
<p class="max-w-sm sm:text-right leading-150" style="max-width: 20ch;">
<a class="b-anchor underline" href="licenses">
What does {{$settings->sit_name}} being licensed and regulated mean? </a>
</p>
</div>
</div>
</section>
<section id="security" class="mt-96 sm:my-160" block-name="exchange-features">
<style></style>
<div class="o-container">
<header class="mx-auto mb-64 text-center">
<h2 class="mb-16 text-28 md:text-42 leading-115 font-medium text-gray-800">
</h2>
<h3 class="text-20 md:text-24 leading-135 text-gray-500">
</h3>
</header>
</div>
<section id="security-insurance" class="o-clip my-96 sm:my-160">
<style>#security-insurance [data-group-security-insurance] {
padding-top: 88%;
transform: translateX(24px);
}

#security-insurance [data-visual-security-insurance] {
right: 0;
transform: translate(-16%);
}

#security-insurance [data-pad-security-insurance] {
right: 0;
}

@media (min-width: 1200px) { #security-insurance [data-group-security-insurance] {
padding-top: 70%;
transform: none;
} }

@media (min-width: 1200px) { #security-insurance [data-visual-security-insurance] {
transform: translate(-2%, 1%) scale(0.8);
} }

</style>
<div class="o-container">
<div class="o-row items-center justify-between">
<div class="o-col w-full sm:w-1/2 mb-32 sm:my-0 sm:order-2">
<div class="relative pt-160" data-group-security-insurance>
<img class="o-visual top-0" src="temp/custom/media/pages/security/ca8a79a8cd-1631610936/illustration-security-pad.svg" alt="" data-pad-security-insurance>
<img class="o-visual top-0" src="temp/custom/media/pages/security/ec785ef6d2-1631610937/illustration-security-shield.svg" alt="" data-visual-security-insurance>
</div>
</div>
<div class="o-col sm:w-1/2 lg:w-5/12 relative">
<h2 class="b-heading mb-16">
$375 Million Insurance </h2>
<div class="s-text2 m-clip">
<p>{{$settings->sit_name}} partners with the foremost providers of security in the blockchain space, including BitGo and Ledger Vault, among others. Collectively, they carry $375M in insurance protections for digital assets held on the {{$settings->sit_name}} platform via the most prestigious syndicates of underwriters.</p> </div>
<div class="mt-16">
<a class="b-link2" href="abou">
Read More
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
</div>
</div>
</section>
<section id="security-protection" class="o-clip my-96 sm:my-160">
<style>#security-protection [data-group-security-protection] {
padding-top: 98.5%;
transform: translateX(-24px);
}

@media (min-width: 1200px) { #security-protection [data-group-security-protection] {
padding-top: 70%;
transform: none;
} }

</style>
<div class="o-container">
<div class="o-row items-center justify-between">
<div class="o-col w-full sm:w-1/2 mb-32 sm:my-0 ">
<div class="relative pt-160" data-group-security-protection>
<img class="o-visual top-0" src="temp/custom/media/pages/security/7d6968baae-1632402823/illustration-security-lock-armanino.svg" alt="" data-visual-security-protection>
</div>
</div>
<div class="o-col sm:w-1/2 lg:w-5/12 relative">
<h2 class="b-heading mb-16">
Real-Time Reserves Audit </h2>
<div class="s-text2 m-clip">
<p>To increase transparency, {{$settings->sit_name}} is working with Armanino to conduct a Proof of Reserves assessment and provide real-time attestations over the company’s custodial holdings. With this pioneering move for the crypto lending space, we give you the ultimate peace of mind that {{$settings->sit_name}} is able to meet client obligations at all times.</p> </div>

</div>
</div>
</div>
</section>
<section id="security-wallet" class="o-clip my-96 sm:my-160">
<style>#security-wallet [data-group-security-wallet] {
padding-top: 88.4%;
transform: translateX(-24px);
}

#security-wallet [data-pad-security-wallet] {
left: 0;
}

#security-wallet [data-visual-security-wallet] {
left: 0;
transform: translate(15%, 3%) scale(1.1);
}

@media (min-width: 1200px) { #security-wallet [data-group-security-wallet] {
padding-top: 63%;
transform: none;
} }

@media (min-width: 1200px) { #security-wallet [data-visual-security-wallet] {
transform: translate(17%, 7%) scale(0.85);
} }

</style>
<div class="o-container">
<div class="o-row items-center justify-between">
<div class="o-col w-full sm:w-1/2 mb-32 sm:my-0 sm:order-2">
<div class="relative pt-160" data-group-security-wallet>
<img class="o-visual top-0" src="temp/custom/media/pages/security/baf471a877-1631610936/illustration-pad-left.svg" alt="" data-pad-security-wallet>
<img class="o-visual top-0" src="temp/custom/media/pages/security/ca0f0a9268-1631610937/illustration-wallet-coins.svg" alt="" data-visual-security-wallet>
</div>
</div>
<div class="o-col sm:w-1/2 lg:w-5/12 relative">
<h2 class="b-heading mb-16">
Military-Grade Storage, Full Flexibility </h2>
<div class="s-text2 m-clip">
<p>Your assets are stored in military-grade Class III vaults while our partners allow for instant access to your funds and full independence from third-party providers.</p> </div>
<div class="mt-16">
<a class="b-link2" href="https://www.bitgo.com/services/custody/" target="_blank" rel="noopener noreferrer">
Read More
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
</div>
</div>
</section>
<section id="security-compliance" class="o-clip my-96 sm:my-160">
<style>#security-compliance [data-group-security-compliance] {
padding-top: 88.2%;
transform: translateX(24px);
}

#security-compliance [data-pad-security-compliance] {
right: 0;
}

#security-compliance [data-visual-security-compliance] {
right: 0;
transform: scale(0.9) translate(-17%);
}

@media (min-width: 1200px) { #security-compliance [data-group-security-compliance] {
padding-top: 63%;
transform: none;
} }

@media (min-width: 1200px) { #security-compliance [data-visual-security-compliance] {
transform: translate(-16%, 4%) scale(0.92);
} }

</style>
<div class="o-container">
<div class="o-row items-center justify-between">
<div class="o-col w-full sm:w-1/2 mb-32 sm:my-0 ">
<div class="relative pt-160" data-group-security-compliance>
<img class="o-visual top-0" src="temp/custom/media/pages/security/7ea4c90cf9-1631610936/illustration-pad-right.svg" alt="" data-pad-security-compliance>
<img class="o-visual top-0" src="temp/custom/media/pages/security/b403ed8686-1631610936/illustration-profile-jumio-content.svg" alt="" data-visual-security-compliance>
</div>
</div>
<div class="o-col sm:w-1/2 lg:w-5/12 relative">
<h2 class="b-heading mb-16">
Regulatory Compliance &amp; Anti-Money Laundering </h2>
<div class="s-text2 m-clip">
<p>{{$settings->sit_name}} uses Jumio to adhere to the strictest KYC and AML global compliance standards. Jumio is also trusted by Microsoft, Oracle, Monzo, and HSBC.</p> </div>
</div>
</div>
</div>
</section>
</section>
<section class="o-clip py-128 sm:pt-160 sm:pb-0 bg-color-50 sm:overflow-visible" block-name="app-screens">
<div class=" o-container">
<h2 class="b-heading text-center">
Platform Security </h2>
<div class="o-row" ob-mockup>
<div class="o-col w-full sm:w-1/2">
<div class="mt-80 sm:my-screen-1/2 text-center sm:text-left" ob-mockup-item>
<h3 class="b-heading mb-8 md:mb-24">
2FA Authentication </h3>
<p class="text-18 md:text-18 leading-150 text-color-500 sm:w-2/3">
SMS Verifications, Email Verifications, Authenticator App Support </p>
<div class="flex justify-center sm:hidden mt-24">
<div class="b-app-mockup relative z-10 inline -mb-20" ob-mockup-item-visual>
<img src="temp/custom/media/pages/security/220f492c86-1631610937/mockup-180x.png" sizes="180px" width="180" height="364" alt="">
<img class="b-app-mockup__screen" src="temp/custom/media/pages/security/941b9e66e1-1631610937/mockup-2fa-152x.png" sizes="152px" width="152" height="326" alt="">
<svg class="o-shape shape-1" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.2925 7.92294L26.6329 1.70034C26.3407 1.54389 25.9869 1.54389 25.6946 1.70034L1.91406 14.3944V27.3588L38.2925 7.92294Z" stroke="#3A8EF6" stroke-width="2" />
</svg>
<svg class="o-shape shape-2" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.3706 21.398L26.7111 27.6206C26.4188 27.777 26.065 27.777 25.7728 27.6206L1.99219 14.9265V1.96216L38.3706 21.398Z" stroke="#3A8EF6" stroke-width="2" />
<path d="M1.99219 27.9622L14.038 21.4587L1.99219 14.9623V27.9622Z" stroke="#3A8EF6" stroke-width="2" />
</svg>
<svg class="o-shape shape-3" width="40" height="30" viewBox="0 0 40 30" fill="none">
<path d="M37.5718 8.64547L25.9122 2.42288C25.62 2.26642 25.2662 2.26642 24.9739 2.42288L1.19336 15.117V28.0813L37.5718 8.64547Z" stroke="#1E4DD8" stroke-width="2" />
<path d="M1.19336 2.08126L13.2392 8.5848L1.19336 15.0812V2.08126Z" stroke="#1E4DD8" stroke-width="2" />
</svg> </div>
</div>
</div>
<div class="mt-80 sm:my-screen-1/2 text-center sm:text-left" ob-mockup-item>
<h3 class="b-heading mb-8 md:mb-24">
Biometric Identification </h3>
<p class="text-18 md:text-18 leading-150 text-color-500 sm:w-2/3">
Using Fingerprint or Face Recognition </p>
<!-- <div class="flex justify-center sm:hidden mt-24">
<div class="b-app-mockup relative z-10 inline -mb-20" ob-mockup-item-visual>
<img src="temp/custom/media/wejio.png"  sizes="152px" width="152" height="364" alt="">
<img class="b-app-mockup__screen" src="temp/custom/media/wejio.png" sizes="152px" width="152" height="326" alt="">
<svg class="o-shape shape-1" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.2925 7.92294L26.6329 1.70034C26.3407 1.54389 25.9869 1.54389 25.6946 1.70034L1.91406 14.3944V27.3588L38.2925 7.92294Z" stroke="#3A8EF6" stroke-width="2" /> -->
</svg>
<svg class="o-shape shape-2" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.3706 21.398L26.7111 27.6206C26.4188 27.777 26.065 27.777 25.7728 27.6206L1.99219 14.9265V1.96216L38.3706 21.398Z" stroke="#3A8EF6" stroke-width="2" />
<path d="M1.99219 27.9622L14.038 21.4587L1.99219 14.9623V27.9622Z" stroke="#3A8EF6" stroke-width="2" />
</svg>
<svg class="o-shape shape-3" width="40" height="30" viewBox="0 0 40 30" fill="none">
<path d="M37.5718 8.64547L25.9122 2.42288C25.62 2.26642 25.2662 2.26642 24.9739 2.42288L1.19336 15.117V28.0813L37.5718 8.64547Z" stroke="#1E4DD8" stroke-width="2" />
<path d="M1.19336 2.08126L13.2392 8.5848L1.19336 15.0812V2.08126Z" stroke="#1E4DD8" stroke-width="2" />
</svg> </div>
</div>
</div>
<div class="mt-80 sm:my-screen-1/2 text-center sm:text-left" ob-mockup-item>
<h3 class="b-heading mb-8 md:mb-24">
24/7 Support </h3>
<p class="text-18 md:text-18 leading-150 text-color-500 sm:w-2/3">
Excellent rated Customer Support available through chat or email </p>
<div class="flex justify-center sm:hidden mt-24">
<div class="b-app-mockup relative z-10 inline -mb-20" ob-mockup-item-visual>
<!-- <img src="temp/custom/media/pages/security/220f492c86-1631610937/mockup-180x.png"  sizes="180px" width="180" height="364" alt=""> -->
<img class="b-app-mockup__screen" src="temp/custom/media/pages/security/6046ac5e26-1631610937/mockup-support-152x.png"  sizes="152px" width="152" height="326" alt="">
<svg class="o-shape shape-1" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.2925 7.92294L26.6329 1.70034C26.3407 1.54389 25.9869 1.54389 25.6946 1.70034L1.91406 14.3944V27.3588L38.2925 7.92294Z" stroke="#3A8EF6" stroke-width="2" />
</svg>
<svg class="o-shape shape-2" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.3706 21.398L26.7111 27.6206C26.4188 27.777 26.065 27.777 25.7728 27.6206L1.99219 14.9265V1.96216L38.3706 21.398Z" stroke="#3A8EF6" stroke-width="2" />
<path d="M1.99219 27.9622L14.038 21.4587L1.99219 14.9623V27.9622Z" stroke="#3A8EF6" stroke-width="2" />
</svg>
<svg class="o-shape shape-3" width="40" height="30" viewBox="0 0 40 30" fill="none">
<path d="M37.5718 8.64547L25.9122 2.42288C25.62 2.26642 25.2662 2.26642 24.9739 2.42288L1.19336 15.117V28.0813L37.5718 8.64547Z" stroke="#1E4DD8" stroke-width="2" />
<path d="M1.19336 2.08126L13.2392 8.5848L1.19336 15.0812V2.08126Z" stroke="#1E4DD8" stroke-width="2" />
</svg> </div>
</div>
</div>
<div class="mt-80 sm:my-screen-1/2 text-center sm:text-left" ob-mockup-item>
<h3 class="b-heading mb-8 md:mb-24">
Whitelisting </h3>
<p class="text-18 md:text-18 leading-150 text-color-500 sm:w-2/3">
Manage your crypto addresses or improve the security of your account even further by enabling Address Whitelisting </p>
<div class="flex justify-center sm:hidden mt-24">
<div class="b-app-mockup relative z-10 inline -mb-20" ob-mockup-item-visual>
<!-- <img src="temp/custom/media/pages/security/220f492c86-1631610937/mockup-180x.png"  height="364" alt="">
<img class="b-app-mockup__screen" src="temp/custom/media/pages/security/adde9d183c-1637592143/nexo-security-whitelisting-152x.png"  sizes="152px" width="152" height="326" alt=""> -->
<svg class="o-shape shape-1" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.2925 7.92294L26.6329 1.70034C26.3407 1.54389 25.9869 1.54389 25.6946 1.70034L1.91406 14.3944V27.3588L38.2925 7.92294Z" stroke="#3A8EF6" stroke-width="2" />
</svg>
<svg class="o-shape shape-2" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.3706 21.398L26.7111 27.6206C26.4188 27.777 26.065 27.777 25.7728 27.6206L1.99219 14.9265V1.96216L38.3706 21.398Z" stroke="#3A8EF6" stroke-width="2" />
<path d="M1.99219 27.9622L14.038 21.4587L1.99219 14.9623V27.9622Z" stroke="#3A8EF6" stroke-width="2" />
</svg>
<svg class="o-shape shape-3" width="40" height="30" viewBox="0 0 40 30" fill="none">
<path d="M37.5718 8.64547L25.9122 2.42288C25.62 2.26642 25.2662 2.26642 24.9739 2.42288L1.19336 15.117V28.0813L37.5718 8.64547Z" stroke="#1E4DD8" stroke-width="2" />
<path d="M1.19336 2.08126L13.2392 8.5848L1.19336 15.0812V2.08126Z" stroke="#1E4DD8" stroke-width="2" />
</svg> </div>
</div>
</div>
<div class="mt-80 sm:my-screen-1/2 text-center sm:text-left" ob-mockup-item>
<h3 class="b-heading mb-8 md:mb-24">
Withdrawal Confirmations &amp; Log-in Alerts </h3>
<p class="text-18 md:text-18 leading-150 text-color-500 sm:w-2/3">
Keep full control over your account </p>
<div class="flex justify-center sm:hidden mt-24">
<div class="b-app-mockup relative z-10 inline -mb-20" ob-mockup-item-visual>
<img src="temp/custom/media/pages/security/220f492c86-1631610937/mockup-180x.png"  sizes="180px" width="180" height="364" alt="">
<img class="b-app-mockup__screen" src="temp/custom/media/pages/security/a9e46b1aa3-1631610937/mockup-logins-152x.png"  sizes="152px" width="152" height="326" alt="">
<svg class="o-shape shape-1" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.2925 7.92294L26.6329 1.70034C26.3407 1.54389 25.9869 1.54389 25.6946 1.70034L1.91406 14.3944V27.3588L38.2925 7.92294Z" stroke="#3A8EF6" stroke-width="2" />
</svg>
<svg class="o-shape shape-2" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.3706 21.398L26.7111 27.6206C26.4188 27.777 26.065 27.777 25.7728 27.6206L1.99219 14.9265V1.96216L38.3706 21.398Z" stroke="#3A8EF6" stroke-width="2" />
<path d="M1.99219 27.9622L14.038 21.4587L1.99219 14.9623V27.9622Z" stroke="#3A8EF6" stroke-width="2" />
</svg>
<svg class="o-shape shape-3" width="40" height="30" viewBox="0 0 40 30" fill="none">
<path d="M37.5718 8.64547L25.9122 2.42288C25.62 2.26642 25.2662 2.26642 24.9739 2.42288L1.19336 15.117V28.0813L37.5718 8.64547Z" stroke="#1E4DD8" stroke-width="2" />
<path d="M1.19336 2.08126L13.2392 8.5848L1.19336 15.0812V2.08126Z" stroke="#1E4DD8" stroke-width="2" />
</svg> </div>
</div>
</div>
</div>
<div class="o-col hidden sm:block w-1/2 py-160">
<div class="sticky top-50 flex" ob-mockup-sticky>
<div class="b-app-mockup relative z-10 inline-block mx-auto" ob-mockup-visual>

<img class="b-app-mockup__screen" src="temp/custom/media/wejio.png" sizes="252px" width="252" height="541" alt="" ob-mockup-screen>
<!-- <img class="b-app-mockup__screen" src="temp/custom/media/pages/security/6046ac5e26-1631610937/mockup-support-252x.png" sizes="252px" width="252" height="541" alt="" ob-mockup-screen>
<img class="b-app-mockup__screen" src="temp/custom/media/pages/security/adde9d183c-1637592143/nexo-security-whitelisting-252x.png"  sizes="252px" width="252" height="541" alt="" ob-mockup-screen>
<img class="b-app-mockup__screen" src="temp/custom/media/pages/security/a9e46b1aa3-1631610937/mockup-logins-252x.png" sizes="252px" width="252" height="541" alt="" ob-mockup-screen> -->
<svg class="o-shape shape-1" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.2925 7.92294L26.6329 1.70034C26.3407 1.54389 25.9869 1.54389 25.6946 1.70034L1.91406 14.3944V27.3588L38.2925 7.92294Z" stroke="#3A8EF6" stroke-width="2" />
</svg>
<svg class="o-shape shape-2" width="41" height="30" viewBox="0 0 41 30" fill="none">
<path d="M38.3706 21.398L26.7111 27.6206C26.4188 27.777 26.065 27.777 25.7728 27.6206L1.99219 14.9265V1.96216L38.3706 21.398Z" stroke="#3A8EF6" stroke-width="2" />
<path d="M1.99219 27.9622L14.038 21.4587L1.99219 14.9623V27.9622Z" stroke="#3A8EF6" stroke-width="2" />
</svg>
<svg class="o-shape shape-3" width="40" height="30" viewBox="0 0 40 30" fill="none">
<path d="M37.5718 8.64547L25.9122 2.42288C25.62 2.26642 25.2662 2.26642 24.9739 2.42288L1.19336 15.117V28.0813L37.5718 8.64547Z" stroke="#1E4DD8" stroke-width="2" />
<path d="M1.19336 2.08126L13.2392 8.5848L1.19336 15.0812V2.08126Z" stroke="#1E4DD8" stroke-width="2" />
</svg> </div>
</div>
</div>
</div>
</div>
</section>
<section class="s-padded-image-list relative bg-indigo-700 overflow-hidden" block-name="padded-image-list">
<div class="o-container w-full my-104">
<img class="absolute top-0 left-0 w-full object-cover" draggable="false" src="temp/custom/media/pages/security/39d6952ebc-1631610937/shapes.svg" alt="" data-pad>
<!-- <img class="relative mx-auto" draggable="false" src="temp/custom/media/wiw.png"  sizes="996px" width="996" height="505" alt=""> -->
<div class="s-checklist lg:w-4/5 mx-auto mt-48 md:mt-80 sm:pl-64 lg:pl-96 text-white">
<ul>
<li>Live Automated Platform</li>
<li>Fully Audited Smart Contracts</li>
<li>Full Blockchain-Based Smart Contract Security</li>
<li>Military-Grade 256-bit Encryption</li>
<li>Extensive Firewall Server Architecture</li>
<li>Regular Third-Party Penetration Testing and Platform Assessment</li>
</ul> </div>
</div>
</section>
<section id="security" class="mt-96 sm:my-160" block-name="exchange-features">
<style></style>
<div class="o-container">
<header class="mx-auto mb-64 text-center">
<h2 class="mb-16 text-28 md:text-42 leading-115 font-medium text-gray-800">
More Security Features </h2>
<h3 class="text-20 md:text-24 leading-135 text-gray-500">
</h3>
</header>
</div>
<section id="security-standard" class="o-clip my-96 sm:my-160">
<style>#security-standard [data-group-security-standard] {
padding-top: 98.5%;
transform: translateX(24px);
}

@media (min-width: 1200px) { #security-standard [data-group-security-standard] {
padding-top: 70%;
transform: none;
} }

#security-standard [data-visual-security-standard] {
right: 0;
}

</style>
<div class="o-container">
<div class="o-row items-center justify-between">
<div class="o-col w-full sm:w-1/2 mb-32 sm:my-0 sm:order-2">
<div class="relative pt-160" data-group-security-standard>
<img class="o-visual top-0" src="temp/custom/media/pages/security/8414ca69ee-1631610936/illustration-ccss.svg" alt="" data-visual-security-standard>
</div>
</div>
<div class="o-col sm:w-1/2 lg:w-5/12 relative">
<h2 class="b-heading mb-16">
Cryptocurrency Security Standard Level 3 </h2>
<div class="s-text2 m-clip">
<p>To underpin the robustness of the enterprise, {{$settings->sit_name}} is making use of BitGo’s Enterprise Solution which incorporates the Cryptocurrency Security Standard Level 3. The CCSS Level 3 requires multiple actors for all-critical actions, as advanced authentication mechanisms are employed to ensure the authenticity of data, while assets are distributed geographically and organizationally.</p> </div>
<div class="mt-16">
<a class="b-link2" href="https://www2.deloitte.com/mt/en/pages/technology/articles/mt-article-cryptocurrency-security-standard-CCSS.html" target="_blank" rel="noopener noreferrer">
Read More
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
</div>
</div>
</section>
<section id="security-data-protection" class="o-clip my-96 sm:my-160">
<style>#security-data-protection [data-group-security-data-protection] {
padding-top: 98.5%;
transform: translateX(-24px);
}

@media (min-width: 1200px) { #security-data-protection [data-group-security-data-protection] {
padding-top: 70%;
transform: none;
} }

#security-data-protection [data-visual-security-data-protection] {
left: 0;
}

</style>
<div class="o-container">
<div class="o-row items-center justify-between">
<div class="o-col w-full sm:w-1/2 mb-32 sm:my-0 ">
<div class="relative pt-160" data-group-security-data-protection>
<img class="o-visual top-0" src="temp/custom/media/pages/security/cc28829a9e-1631610936/illustration-data-lock.svg" alt="" data-visual-security-data-protection>
</div>
</div>
<div class="o-col sm:w-1/2 lg:w-5/12 relative">
<h2 class="b-heading mb-16">
Data Protection and Confidentiality </h2>
<div class="s-text2 m-clip">
<p>Your personal information is contained behind secured networks and is only accessible to a limited number of persons who are required to keep the information confidential. Аll sensitive/credit information you supply is encrypted via Secure Socket Layer (SSL) technology.</p>
<p>{{$settings->sit_name}} implements a variety of security measures when users enter, submit, or access their information.</p> </div>
</div>
</div>
</div>
</section>
<section id="security-iso-compliant" class="o-clip my-96 sm:my-160">
<style>#security-iso-compliant [data-group-security-iso-compliant] {
padding-top: 98.5%;
transform: translateX(24px);
}

@media (min-width: 1200px) { #security-iso-compliant [data-group-security-iso-compliant] {
padding-top: 70%;
transform: none;
} }

#security-iso-compliant [data-visual-security-iso-compliant] {
right: 0;
}

</style>
<div class="o-container">
<div class="o-row items-center justify-between">
<div class="o-col w-full sm:w-1/2 mb-32 sm:my-0 sm:order-2">
<div class="relative pt-160" data-group-security-iso-compliant>
<img class="o-visual top-0" src="temp/custom/media/pages/security/5eaf3c66ba-1631610936/illustration-iso.svg" alt="" data-visual-security-iso-compliant>
</div>
</div>
<div class="o-col sm:w-1/2 lg:w-5/12 relative">
<h2 class="b-heading mb-16">
Accredited Information Security Management Systems </h2>
<div class="s-text2 m-clip">
<p>ISO/IEC 27001 guarantees that {{$settings->sit_name}} security infrastructure is of the highest standard, thus ensuring the safety of the enterprise and minimizing risks for all clients and investors. Being ISO/IEC 27001 certified, {{$settings->sit_name}} is now raising the bar for the entire blockchain space, by utilizing the most rigorous security policies, impeccable risk assessment, data protection, and state-of-the-art cybersecurity.</p> </div>
<div class="mt-16">
<a class="b-link2" href="about">
Read More
<span class="b-link2__icon b-link2__icon--r">
<i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z" /></svg></i> </span>
</a>
</div>
</div>
</div>
</div>
</section>
</section>
<section id="cta-footer" class="bg-indigo-500 text-white" data-dark-section block-name="text-image-accent">
<style>@media (max-width: 599px) { #cta-footer [data-visual-image-accent] {
margin-bottom: 1.5rem;
} }

#cta-footer [data-visual-image-accent] {
transform: translateY(6%);
}

</style>
<div class="o-container">
<div class="o-row items-center justify-between py-96 lg:py-104 sm:p-0">
<div class="o-col w-full sm:w-7/12 mb-24 sm:m-0 sm:order-2">
<img class="relative z-10 w-full rounded-md" src="temp/custom/media/pages/storage/images/904079a31a-1634560888/nexo-platform-and-app.html" sizes="(max-width: 600px) 100vw, (max-width: 1400px) 50vw, 720px" alt="" data-visual-image-accent>
</div>
<div class="o-col w-full sm:w-5/12 sm:my-64 relative">
<h2 class="b-heading text-white mb-8">
Unleash the <strong>Power of Your Crypto</strong> </h2>
<div class="s-text2 m-clip text-gray-100">
<p>Open your {{$settings->sit_name}} account today and make your cryptocurrency work
and earn money for you in seconds.</p> </div>
<div class="flex items-center mt-24">
<a id="footer-cta" class="b-button b-button--s b-button--mint mr-16" href="register" target="_blank" rel="noopener noreferrer">
Create Account
<span class="ml-6 text-16"><i class="o-icon o-icon--fa-solid"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M285.476 272.971L91.132 467.314c-9.373 9.373-24.569 9.373-33.941 0l-22.667-22.667c-9.357-9.357-9.375-24.522-.04-33.901L188.505 256 34.484 101.255c-9.335-9.379-9.317-24.544.04-33.901l22.667-22.667c9.373-9.373 24.569-9.373 33.941 0L285.475 239.03c9.373 9.372 9.373 24.568.001 33.941z" /></svg></i></span>
</a>
<a class="flex items-center px-8 text-32 hover:opacity-75 transition-opacity duration-1 ease-1" href="#" target="_blank" rel="noopener noreferrer" aria-label="App Store">
<i class="o-icon o-icon--fa-brands"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M318.7 268.7c-.2-36.7 16.4-64.4 50-84.8-18.8-26.9-47.2-41.7-84.7-44.6-35.5-2.8-74.3 20.7-88.5 20.7-15 0-49.4-19.7-76.4-19.7C63.3 141.2 4 184.8 4 273.5q0 39.3 14.4 81.2c12.8 36.7 59 126.7 107.2 125.2 25.2-.6 43-17.9 75.8-17.9 31.8 0 48.3 17.9 76.4 17.9 48.6-.7 90.4-82.5 102.6-119.3-65.2-30.7-61.7-90-61.7-91.9zm-56.6-164.2c27.3-32.4 24.8-61.9 24-72.5-24.1 1.4-52 16.4-67.9 34.9-17.5 19.8-27.8 44.3-25.6 71.9 26.1 2 49.9-11.4 69.5-34.3z" /></svg></i> </a>
<a class="flex items-center px-8 text-24 hover:opacity-75 transition-opacity duration-1 ease-1" href="#" target="_blank" rel="noopener noreferrer" aria-label="Google Play">
<i class="o-icon o-icon--fa-brands"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M325.3 234.3L104.6 13l280.8 161.2-60.1 60.1zM47 0C34 6.8 25.3 19.2 25.3 35.3v441.3c0 16.1 8.7 28.5 21.7 35.3l256.6-256L47 0zm425.2 225.6l-58.9-34.1-65.7 64.5 65.7 64.5 60.1-34.1c18-14.3 18-46.5-1.2-60.8zM104.6 499l280.8-161.2-60.1-60.1L104.6 499z" /></svg></i> </a>
</div>
</div>
</div>
</div>
</section>
@endsection